#ifndef __CDialog__
#define __CDialog__

#include <Basics/CSystemString.hpp>
using Exponent::Basics::CSystemString;

namespace Exponent
{
	namespace GUI
	{
		namespace Basics
		{
			/**
			 * @class CDialog CDialog.hpp
			 * @brief Defines several dialog boxes
			 *
			 * @date 28/08/2004
			 * @author Paul Chana
			 * @version 1.0.0 Initial version
			 *
			 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
			 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
			 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk\n
			 * All content is the Intellectual property of Exp Digital Uk.\n
			 * Certain sections of this code may come from other sources. They are credited where applicable.\n
			 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
			 *
			 * $Id: CDialog.hpp,v 1.5 2007/02/11 02:16:22 paul Exp $
			 */
			class CDialog
			{
			public:

//	===========================================================================

				/**
				 * Put up a message for the user
				 * @param message The message to print
				 * @param title The dialog box title
				 * @param isSerious If true, puts up an eclamation icon
				 */
				static void notifyUser(const CString&message, const CString&title, const bool isSerious = false);

				/**
				 * Get Response from user
				 * @param message The message to print
				 * @param title The dialog box title
				 * @retval true if they clicked ok, false if they clicked cancel
				 */
				static bool promptUser(const CString&message, const CString&title);

				/**
				 * Audible prompt - sounds a ping!
				 */
				static void audioPrompt();

//	===========================================================================

				/**
				 * Open save dialog
				 * @param startingPath The place to start
				 * @param filename On return is filled with the filename they chose, on input this can be a default file name
				 * @param title The title of the window
				 * @param filterDescription A description of the file filter, on mac this is placed in the "message" location, would normally be something like "Text files (*.txt)
				 * @param filterExtension An extension to filter by, doesnt need the *.  at the beggining, so to filter by text filesw you pass "txt"
				 * @code
				 * // Here is an example of how to use the save dialog prompt:
				 * CSystemString path        = CApplication::getApplicationInstallPath();	// This is the starting path for the save dialog - this is the place you want to recommend that your users save to
				 * CSystemString filename    = "Some sensible default name";				// Notice that you dont need to apply the extension
				 * CString title			 = "Save a text file from my application";		// This is a descriptive title for the save window
				 * CString filterDescription = "Text files (*.txt)";						// This is a description of some sort of the file type you are saving
				 * CString filterExtension   = "txt";										// The extension to search for, without the "." at the beggining
				 *
				 * // Now we try and open the dialog
				 * if (CDialog::openSaveDialog(path, filename, title, filterDescription, filterExtension))
				 * {
				 *	   cout << "The user selected a file path to save to and the path was " << filename.getString() << endl;
				 * }
				 * else
				 * {
				 *	   cout << "The user hit cancel" << endl;
				 * }
				 * @endcode
				 */
				static bool openSaveDialog(const CSystemString &startingPath, CSystemString &filename, const CString &title, const CString &filterDescription, const CString &filterExtension);

				/**
				 * Open load file dialog
				 * @param path The place to start ie the default location you recommend that they load from
				 * @param filename On return is filled with the filename they chose. On input can be a suggested filename, or can be blank string if you dont care
				 * @param title The title to display
				 * @param filterDescription A description of the file filter, on mac this is placed in the "message" location, would normally be something like "Text files (*.txt)
				 * @param filterExtension An extension to filter by, doesnt need the *.  at the beggining, so to filter by text filesw you pass "txt"
				 * @code
				 * // Here is an example of how to use the save dialog prompt:
				 * CSystemString path        = CApplication::getApplicationInstallPath();	// This is the starting path for the save dialog - this is the place you want to recommend that your users save to
				 * CSystemString filename    = "Some sensible default name";				// Notice that you dont need to apply the extension
				 * CString title			 = "Save a text file from my application";		// This is a descriptive title for the save window
				 * CString filterDescription = "Text files (*.txt)";						// This is a description of some sort of the file type you are saving
				 * CString filterExtension   = "txt";										// The extension to search for, without the "." at the beggining
				 *
				 * // Now we try and open the dialog
				 * if (CDialog::openFileDialog(path, filename, title, filterDescription, filterExtension))
				 * {
				 *	   cout << "The user selected a file path to load from and the path was " << filename.getString() << endl;
				 * }
				 * else
				 * {
				 *	   cout << "The user hit cancel" << endl;
				 * }
				 * @endcode
				 */
				static bool openFileDialog(const CSystemString &path, CSystemString &filename, const CString &title, const CString &filterDescription, const CString &filterExtension);

				/**
				 * Open a choose folder dialog
				 * @param filename On return is filled with the filename they chose
				 * @param title the window title
				 * @retval bool True if filename is filled properly, false if they clicked cancel
				 */
				static bool openFolderDialog(CSystemString &filename, const CString &title);

//	===========================================================================

			protected:

//	===========================================================================

				const static unsigned long CDIALOG_OK_OPTION;				/**< OK option */
				const static unsigned long CDIALOG_ASTERISK_OPTION;			/**< Asterisk option */
				const static unsigned long CDIALOG_EXCLAMATION_OPTION;		/**< Exclamation option */
				const static unsigned long CDIALOG_HAND_OPTION;				/**< Hand option */
				const static unsigned long CDIALOG_QUESTION_OPTION;			/**< Question option */
				const static unsigned long CDIALOG_SIMPLE_OPTION;			/**< Simple option */
				const static unsigned long CDIALOG_MAX_FILTER_STRING;		/**< Max length of the filter */

//	===========================================================================

			/**
			 * @cond
			 */
			#ifdef WIN32
			/**
			 * @endcond
			 */
				/**
				 * Create the filter for a dialog box
				 * @param filterString The string that on return stores the filter, including all files
				 * @param filterDescription A description of the file filter
				 * @param filterExtension An extension to filter by, maybe *.*
				 */
				static void createDialogFilter(char *filterString, const CSystemString &filterDescription, const CSystemString &filterExtension);
			/**
			 * @cond
			 */
			#else
			/**
			 * @endcond
			 */
				/**
				 * Open file proc
				 * @param theItem The item to check for validity
				 * @param info Our user defined data, hopefully the extension
				 * @param callBackUD The callback parameters
				 * @param filterMode The mode of filtration
				 * @retval Boolean True if the item should be displayed, false otherwise
				 */
				static pascal Boolean fileDialogProc(AEDesc *theItem, void *info, NavCallBackUserData callBackUD, NavFilterModes filterMode);

				/**
				 * Open folder proc
				 * @param theItem The item to check for validity
				 * @param info Our user defined data, hopefully the extension
				 * @param callBackUD The callback parameters
				 * @param filterMode The mode of filtration
				 * @retval Boolean True if the item should be displayed, false otherwise
				 */
				static pascal Boolean folderDialogProc(AEDesc *theItem, void *info, NavCallBackUserData callBackUD, NavFilterModes filterMode);

				/**
				 * Set the default location of a dialog
				 * @param dialogReference The reference to the dialog box to set the location of
				 * @param path The path you want to initialise to
				 */
				static void setDefaultDialogLocation(NavDialogRef dialogReference, const CSystemString &path);
			/**
			 * @cond
			 */
			#endif
			/**
			 * @endcond
			 */
			};
		}
	}
}
#endif	// End of CDialog.hpp